<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class AdminSeeder extends Seeder
{
    public function run(): void
    {
        User::create([
            'name' => 'Admin User',
            'email' => 'admin@property.com',
            'password' => Hash::make('admin123'),
            'role' => 'admin',
            'phone' => '03001234567',
            'address' => 'Admin Address',
        ]);

        // Create test customers
        \App\Models\Customer::factory(10)->create();
        // Create test properties
        \App\Models\Property::factory(5)->create();
    }
}
