@extends('layouts.app')

@section('title', 'Customer Granters')
@section('page-title', $customer->name . ' - Granters')

@section('content')
<div class="row">
    <div class="col-md-12">
        <!-- Customer Info Card -->
        <div class="card mb-4">
            <div class="card-body">
                <div class="row">
                    <div class="col-md-8">
                        <div class="d-flex align-items-center">
                            <div class="avatar bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-3"
                                 style="width: 60px; height: 60px; font-size: 24px;">
                                {{ substr($customer->name, 0, 1) }}
                            </div>
                            <div>
                                <h4 class="mb-0">{{ $customer->name }}</h4>
                                <p class="text-muted mb-0">
                                    <i class="fas fa-phone me-1"></i> {{ $customer->phone }} |
                                    <i class="fas fa-id-card me-1 ms-2"></i> {{ $customer->cnic }}
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4 text-end">
                        <a href="{{ route('customers.show', $customer) }}" class="btn btn-outline-primary">
                            <i class="fas fa-arrow-left me-1"></i> Back to Customer
                        </a>
                        <a href="{{ route('customers.granters.create', $customer) }}" class="btn btn-success">
                            <i class="fas fa-plus me-1"></i> Add Granter
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Granters Card -->
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">All Granters</h5>
                <div>
                    <span class="badge bg-primary">{{ $granters->total() }} Granters</span>
                </div>
            </div>
            <div class="card-body">
                @if($granters->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Name</th>
                                <th>Relationship</th>
                                <th>CNIC</th>
                                <th>Contact</th>
                                <th>Occupation & Income</th>
                                <th>Properties</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($granters as $granter)
                            <tr>
                                <td>{{ $loop->iteration }}</td>
                                <td>
                                    <strong>{{ $granter->name }}</strong>
                                    @if($granter->email)
                                    <div class="small text-muted">{{ $granter->email }}</div>
                                    @endif
                                </td>
                                <td>
                                    <span class="badge bg-info">{{ $granter->relationship }}</span>
                                </td>
                                <td><code>{{ $granter->cnic }}</code></td>
                                <td>
                                    {{ $granter->phone ?: 'N/A' }}
                                    @if($granter->address)
                                    <div class="small text-muted">{{ Str::limit($granter->address, 30) }}</div>
                                    @endif
                                </td>
                                <td>
                                    {{ $granter->occupation ?: 'N/A' }}
                                    @if($granter->company_name)
                                    <div class="small text-muted">{{ $granter->company_name }}</div>
                                    @endif
                                    @if($granter->monthly_income)
                                    <div class="small text-success">
                                        Rs. {{ number_format($granter->monthly_income, 2) }}/month
                                    </div>
                                    @endif
                                </td>
                                <td>
                                    @if($granter->properties->count() > 0)
                                    <div class="dropdown">
                                        <button class="btn btn-sm btn-outline-primary dropdown-toggle" type="button"
                                                data-bs-toggle="dropdown">
                                            {{ $granter->properties->count() }} Properties
                                        </button>
                                        <ul class="dropdown-menu">
                                            @foreach($granter->properties as $property)
                                            <li>
                                                <a class="dropdown-item" href="{{ route('properties.show', $property) }}">
                                                    {{ $property->name }}
                                                    @if($property->pivot->guarantee_amount)
                                                    <br><small class="text-muted">
                                                        Guarantee: Rs. {{ number_format($property->pivot->guarantee_amount, 2) }}
                                                    </small>
                                                    @endif
                                                </a>
                                            </li>
                                            @endforeach
                                        </ul>
                                    </div>
                                    @else
                                    <span class="badge bg-secondary">No Properties</span>
                                    @endif
                                </td>
                                <td>
                                    <span class="badge bg-{{ $granter->status == 'active' ? 'success' : 'secondary' }}">
                                        {{ ucfirst($granter->status) }}
                                    </span>
                                </td>
                                <td>
                                    <div class="btn-group btn-group-sm">
                                        <a href="{{ route('customers.granters.show', [$customer, $granter]) }}"
                                           class="btn btn-info" title="View">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="{{ route('customers.granters.edit', [$customer, $granter]) }}"
                                           class="btn btn-warning" title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <form action="{{ route('customers.granters.destroy', [$customer, $granter]) }}"
                                              method="POST" class="d-inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-danger"
                                                    onclick="return confirm('Delete this granter?')" title="Delete">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <div class="d-flex justify-content-center mt-3">
                    {{ $granters->links() }}
                </div>

                <!-- Statistics -->
                <div class="row mt-4">
                    <div class="col-md-3">
                        <div class="card bg-primary text-white">
                            <div class="card-body text-center py-2">
                                <h5 class="mb-0">{{ $granters->total() }}</h5>
                                <small>Total Granters</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card bg-success text-white">
                            <div class="card-body text-center py-2">
                                <h5 class="mb-0">{{ $granters->where('status', 'active')->count() }}</h5>
                                <small>Active</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card bg-info text-white">
                            <div class="card-body text-center py-2">
                                <h5 class="mb-0">{{ $granters->where('status', 'inactive')->count() }}</h5>
                                <small>Inactive</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card bg-warning text-white">
                            <div class="card-body text-center py-2">
                                @php
                                    $totalGuarantee = 0;
                                    foreach($granters as $granter) {
                                        $totalGuarantee += $granter->properties->sum('pivot.guarantee_amount');
                                    }
                                @endphp
                                <h5 class="mb-0">Rs. {{ number_format($totalGuarantee, 0) }}</h5>
                                <small>Total Guarantee</small>
                            </div>
                        </div>
                    </div>
                </div>
                @else
                <div class="text-center py-5">
                    <i class="fas fa-users fa-3x text-muted mb-3"></i>
                    <h5>No Granters Found</h5>
                    <p class="text-muted">No granters have been added for this customer.</p>
                    <a href="{{ route('customers.granters.create', $customer) }}" class="btn btn-primary">
                        <i class="fas fa-plus me-2"></i> Add First Granter
                    </a>
                </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection
