@extends('layouts.app')

@section('title', 'Edit Property')
@section('page-title', 'Edit Property')

@section('content')
<div class="row justify-content-center">
    <div class="col-md-10">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Edit Property Information</h5>
            </div>
            <div class="card-body">
                <form method="POST" action="{{ route('properties.update', $property) }}">
                    @csrf
                    @method('PUT')

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="name" class="form-label">Property Name *</label>
                                <input type="text" class="form-control @error('name') is-invalid @enderror"
                                       id="name" name="name" value="{{ old('name', $property->name) }}"
                                       placeholder="Enter property name" required>
                                @error('name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="location" class="form-label">Location *</label>
                                <textarea class="form-control @error('location') is-invalid @enderror"
                                          id="location" name="location" rows="2"
                                          placeholder="Enter property address" required>{{ old('location', $property->location) }}</textarea>
                                @error('location')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="status" class="form-label">Status *</label>
                                <select class="form-control @error('status') is-invalid @enderror"
                                        id="status" name="status" required>
                                    <option value="active" {{ old('status', $property->status) == 'active' ? 'selected' : '' }}>Active</option>
                                    <option value="completed" {{ old('status', $property->status) == 'completed' ? 'selected' : '' }}>Completed</option>
                                    <option value="cancelled" {{ old('status', $property->status) == 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                                </select>
                                @error('status')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="description" class="form-label">Description</label>
                                <textarea class="form-control @error('description') is-invalid @enderror"
                                          id="description" name="description" rows="3"
                                          placeholder="Enter property description">{{ old('description', $property->description) }}</textarea>
                                @error('description')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <!-- Property Summary (Readonly) -->
                    <div class="row mt-3">
                        <div class="col-md-12">
                            <div class="card bg-light">
                                <div class="card-body">
                                    <h6 class="card-title">Property Summary</h6>
                                    <div class="row">
                                        <div class="col-md-3">
                                            <small class="text-muted">Total Price:</small>
                                            <p class="mb-1"><strong>Rs. {{ number_format($property->total_price, 2) }}</strong></p>
                                        </div>
                                        <div class="col-md-3">
                                            <small class="text-muted">Down Payment:</small>
                                            <p class="mb-1"><strong>Rs. {{ number_format($property->down_payment, 2) }}</strong></p>
                                        </div>
                                        <div class="col-md-3">
                                            <small class="text-muted">Installment Amount:</small>
                                            <p class="mb-1"><strong>Rs. {{ number_format($property->installment_amount, 2) }}</strong></p>
                                        </div>
                                        <div class="col-md-3">
                                            <small class="text-muted">Installment Years:</small>
                                            <p class="mb-1"><strong>{{ $property->installment_years }} Years</strong></p>
                                        </div>
                                        <div class="col-md-3">
                                            <small class="text-muted">Total Installments:</small>
                                            <p class="mb-1"><strong>{{ $property->total_installments }}</strong></p>
                                        </div>
                                        <div class="col-md-3">
                                            <small class="text-muted">Created:</small>
                                            <p class="mb-1"><strong>{{ $property->created_at->format('d M Y') }}</strong></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="mt-4">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save me-2"></i> Update Property
                        </button>
                        <a href="{{ route('properties.show', $property) }}" class="btn btn-info">
                            <i class="fas fa-eye me-2"></i> View Details
                        </a>
                        <a href="{{ route('properties.index') }}" class="btn btn-secondary">
                            <i class="fas fa-times me-2"></i> Cancel
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
