@extends('layouts.app')

@section('title', 'Properties')
@section('page-title', 'Properties Management')

@section('content')
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0">All Properties</h5>
        <a href="{{ route('properties.create') }}" class="btn btn-primary">
            <i class="fas fa-plus me-2"></i> Add New Property
        </a>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Property Name</th>
                        <th>Location</th>
                        <th>Total Price</th>
                        <th>Installments</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($properties as $property)
                    <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>
                            <strong>{{ $property->name }}</strong>
                            <div class="small text-muted">{{ $property->description }}</div>
                        </td>
                        <td>{{ $property->location }}</td>
                        <td>
                            <strong>Rs. {{ number_format($property->total_price, 2) }}</strong>
                            <div class="small text-muted">
                                Down: Rs. {{ number_format($property->down_payment, 2) }}
                            </div>
                        </td>
                        <td>
                            <div class="progress" style="height: 20px;">
                                @php
                                    $progress = $property->installments_count ?
                                        ($property->installments->where('status', 'paid')->count() / $property->total_installments) * 100 : 0;
                                @endphp
                                <div class="progress-bar bg-success" role="progressbar"
                                     style="width: {{ $progress }}%">
                                    {{ round($progress) }}%
                                </div>
                            </div>
                            <div class="small text-muted mt-1">
                                {{ $property->installments->where('status', 'paid')->count() }}/{{ $property->total_installments }} paid
                            </div>
                        </td>
                        <td>
                            <span class="badge bg-{{ $property->status == 'active' ? 'success' : ($property->status == 'completed' ? 'primary' : 'danger') }}">
                                {{ ucfirst($property->status) }}
                            </span>
                        </td>
                        <td>
                            <div class="btn-group" role="group">
                                <a href="{{ route('properties.show', $property) }}" class="btn btn-sm btn-info">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <a href="{{ route('properties.edit', $property) }}" class="btn btn-sm btn-warning">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <form action="{{ route('properties.destroy', $property) }}" method="POST" class="d-inline">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <div class="d-flex justify-content-center">
            {{ $properties->links() }}
        </div>
    </div>
</div>
@endsection
