@extends('layouts.app')

@section('title', 'Generated Report')
@section('page-title', $title)

@section('content')
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0">{{ $title }}</h5>
        <div>
            <button class="btn btn-success" onclick="exportToExcel()">
                <i class="fas fa-download me-2"></i> Export
            </button>
            <button class="btn btn-primary" onclick="window.print()">
                <i class="fas fa-print me-2"></i> Print
            </button>
        </div>
    </div>

    <div class="card-body">
        <!-- Report Summary -->
        <div class="row mb-4">
            <div class="col-md-6">
                <div class="card bg-primary text-white">
                    <div class="card-body text-center">
                        <h3 class="mb-0">{{ $totalCount }}</h3>
                        <small>Total Payments</small>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="card bg-success text-white">
                    <div class="card-body text-center">
                        <h3 class="mb-0">Rs. {{ number_format($totalAmount, 2) }}</h3>
                        <small>Total Amount</small>
                    </div>
                </div>
            </div>
        </div>

        <!-- Payments Table -->
        @if($payments->count() > 0)
        <div class="table-responsive">
            <table class="table table-hover" id="reportTable">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Transaction ID</th>
                        <th>Customer</th>
                        <th>Property</th>
                        <th>Date</th>
                        <th>Amount</th>
                        <th>Method</th>
                        <th>Reference</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($payments as $payment)
                    <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td><code>{{ $payment->transaction_id }}</code></td>
                        <td>{{ $payment->customer->name }}</td>
                        <td>{{ $payment->installment->property->name }}</td>
                        <td>{{ $payment->payment_date->format('d/m/Y') }}</td>
                        <td>Rs. {{ number_format($payment->amount, 2) }}</td>
                        <td>{{ ucfirst(str_replace('_', ' ', $payment->payment_method)) }}</td>
                        <td>{{ $payment->reference_number ?: 'N/A' }}</td>
                    </tr>
                    @endforeach
                </tbody>
                <tfoot>
                    <tr class="table-success">
                        <td colspan="5" class="text-end"><strong>Total:</strong></td>
                        <td colspan="3">
                            <strong>Rs. {{ number_format($totalAmount, 2) }}</strong>
                        </td>
                    </tr>
                </tfoot>
            </table>
        </div>
        @else
        <div class="text-center py-5">
            <i class="fas fa-file-excel fa-3x text-muted mb-3"></i>
            <h5>No Payments Found</h5>
            <p class="text-muted">No payments were recorded for the selected period.</p>
        </div>
        @endif
    </div>
</div>

@push('scripts')
<script>
    function exportToExcel() {
        const rows = [];
        const headers = ['Transaction ID', 'Customer', 'Property', 'Payment Date', 'Amount', 'Payment Method', 'Reference Number'];

        $('#reportTable tbody tr').each(function() {
            const row = [];
            row.push($(this).find('td:nth-child(2) code').text().trim());
            row.push($(this).find('td:nth-child(3)').text().trim());
            row.push($(this).find('td:nth-child(4)').text().trim());
            row.push($(this).find('td:nth-child(5)').text().trim());
            row.push($(this).find('td:nth-child(6)').text().replace('Rs.', '').trim());
            row.push($(this).find('td:nth-child(7)').text().trim());
            row.push($(this).find('td:nth-child(8)').text().trim());

            rows.push(row.join(','));
        });

        const csvContent = [headers.join(','), ...rows].join('\n');
        const blob = new Blob([csvContent], { type: 'text/csv' });
        const url = window.URL.createObjectURL(blob);
        const a = document.createElement('a');
        a.href = url;
        a.download = `payment_report_${new Date().toISOString().split('T')[0]}.csv`;
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a);
    }
</script>
@endpush
@endsection
