Route::get('/customers/{customer}/installments', function($customerId) {
    $installments = Installment::where('customer_id', $customerId)
        ->with('property')
        ->whereRaw('amount > paid_amount')
        ->orderBy('due_date', 'asc')
        ->get()
        ->map(function($installment) {
            return [
                'id' => $installment->id,
                'property_name' => $installment->property->name,
                'installment_number' => $installment->installment_number,
                'due_date' => $installment->due_date->format('d/m/Y'),
                'remaining_amount' => $installment->remaining_amount,
                'status' => $installment->status
            ];
        });

    return response()->json($installments);
});

Route::get('/installments/{installment}', function($installmentId) {
    $installment = Installment::with('property')->find($installmentId);

    if (!$installment) {
        return response()->json(['error' => 'Installment not found'], 404);
    }

    return response()->json([
        'property' => $installment->property,
        'amount' => $installment->amount,
        'paid_amount' => $installment->paid_amount,
        'remaining_amount' => $installment->remaining_amount,
        'due_date' => $installment->due_date->format('d M Y'),
        'status' => $installment->status
    ]);
});
