<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\PropertyController;
use App\Http\Controllers\CustomerController;
use App\Http\Controllers\InstallmentController;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\ReportController;

// Authentication Routes
Route::get('/login', [AuthController::class, 'showLogin'])->name('login');
Route::post('/login', [AuthController::class, 'login']);
Route::get('/register', [AuthController::class, 'showRegister'])->name('register');
Route::post('/register', [AuthController::class, 'register']);
Route::post('/logout', [AuthController::class, 'logout'])->name('logout');

// Protected Routes
Route::middleware(['auth'])->group(function () {
    // Dashboard
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
    Route::get('/', [DashboardController::class, 'index']);

    // Properties
    Route::resource('properties', PropertyController::class);

    Route::resource('properties', PropertyController::class);
    Route::resource('customers', CustomerController::class);
    Route::resource('installments', InstallmentController::class)->except(['create', 'store']);
    Route::resource('payments', PaymentController::class);

    // Customers
    Route::resource('customers', CustomerController::class);

    // Additional customer document routes
Route::delete('customers/{customer}/delete-document', [CustomerController::class, 'deleteDocument'])
    ->name('customers.delete-document');

Route::get('customers/{customer}/download/{type}/{index?}', [CustomerController::class, 'downloadDocument'])
    ->name('customers.download-document');

Route::get('customers/{customer}/download-all', [CustomerController::class, 'downloadAllDocuments'])
    ->name('customers.download-all');

// Export routes
Route::get('customers/export', [CustomerController::class, 'export'])
    ->name('customers.export');

    // Installments
    Route::resource('installments', InstallmentController::class)->except(['create', 'store']);
    Route::post('/installments/{installment}/mark-paid', [InstallmentController::class, 'markAsPaid'])->name('installments.mark-paid');

    // Payments
    Route::resource('payments', PaymentController::class);

    // Reports
    Route::get('/reports', [ReportController::class, 'index'])->name('reports.index');
    Route::get('/reports/properties', [ReportController::class, 'properties'])->name('reports.properties');
    Route::get('/reports/customers', [ReportController::class, 'customers'])->name('reports.customers');
    Route::get('/reports/payments', [ReportController::class, 'payments'])->name('reports.payments');

    // Reports Routes
    Route::prefix('reports')->name('reports.')->group(function () {
    Route::get('/', [ReportController::class, 'index'])->name('index');
    Route::get('/properties', [ReportController::class, 'properties'])->name('properties');
    Route::get('/customers', [ReportController::class, 'customers'])->name('customers');
    Route::get('/payments', [ReportController::class, 'payments'])->name('payments');
    Route::get('/installments', [ReportController::class, 'installments'])->name('installments');
    Route::get('/generate', [ReportController::class, 'generate'])->name('generate');
    Route::get('/dashboard', [ReportController::class, 'dashboard'])->name('dashboard');
});

// Customer Documents Routes
Route::prefix('customers/{customer}')->group(function () {
    // Documents
    Route::prefix('documents')->name('customers.documents.')->group(function () {
        Route::get('/', [CustomerDocumentController::class, 'index'])->name('index');
        Route::get('/create', [CustomerDocumentController::class, 'create'])->name('create');
        Route::post('/', [CustomerDocumentController::class, 'store'])->name('store');
        Route::get('/{document}', [CustomerDocumentController::class, 'show'])->name('show');
        Route::get('/{document}/edit', [CustomerDocumentController::class, 'edit'])->name('edit');
        Route::put('/{document}', [CustomerDocumentController::class, 'update'])->name('update');
        Route::delete('/{document}', [CustomerDocumentController::class, 'destroy'])->name('destroy');
        Route::post('/{document}/verify', [CustomerDocumentController::class, 'verify'])->name('verify');
        Route::get('/{document}/download', [CustomerDocumentController::class, 'download'])->name('download');
    });



// Export routes
Route::get('customers/export', [CustomerController::class, 'export'])
    ->name('customers.export');

    // Granters
    Route::prefix('granters')->name('customers.granters.')->group(function () {
        Route::get('/', [GranterController::class, 'index'])->name('index');
        Route::get('/create', [GranterController::class, 'create'])->name('create');
        Route::post('/', [GranterController::class, 'store'])->name('store');
        Route::get('/{granter}', [GranterController::class, 'show'])->name('show');
        Route::get('/{granter}/edit', [GranterController::class, 'edit'])->name('edit');
        Route::put('/{granter}', [GranterController::class, 'update'])->name('update');
        Route::delete('/{granter}', [GranterController::class, 'destroy'])->name('destroy');
        Route::post('/{granter}/attach-property', [GranterController::class, 'attachProperty'])->name('attach-property');
        Route::delete('/{granter}/detach-property/{property}', [GranterController::class, 'detachProperty'])->name('detach-property');
    });
});
});
