<?php $__env->startSection('title', 'Payments'); ?>
<?php $__env->startSection('page-title', 'Payment Management'); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0">All Payments</h5>
        <div>
            <a href="<?php echo e(route('payments.create')); ?>" class="btn btn-primary">
                <i class="fas fa-plus me-2"></i> Record New Payment
            </a>
            <button class="btn btn-success" onclick="exportToExcel()">
                <i class="fas fa-download me-2"></i> Export
            </button>
        </div>
    </div>

    <div class="card-body">
        <!-- Filters -->
        <div class="row mb-4">
            <div class="col-md-3">
                <div class="input-group">
                    <span class="input-group-text"><i class="fas fa-search"></i></span>
                    <input type="text" id="searchInput" class="form-control" placeholder="Search payments...">
                </div>
            </div>
            <div class="col-md-2">
                <select id="statusFilter" class="form-control">
                    <option value="">All Status</option>
                    <option value="completed">Completed</option>
                    <option value="pending">Pending</option>
                    <option value="failed">Failed</option>
                    <option value="refunded">Refunded</option>
                </select>
            </div>
            <div class="col-md-2">
                <select id="methodFilter" class="form-control">
                    <option value="">All Methods</option>
                    <option value="cash">Cash</option>
                    <option value="bank_transfer">Bank Transfer</option>
                    <option value="cheque">Cheque</option>
                    <option value="online">Online</option>
                </select>
            </div>
            <div class="col-md-2">
                <input type="date" id="startDateFilter" class="form-control" placeholder="From Date">
            </div>
            <div class="col-md-2">
                <input type="date" id="endDateFilter" class="form-control" placeholder="To Date">
            </div>
            <div class="col-md-1">
                <button class="btn btn-outline-secondary w-100" onclick="resetFilters()">
                    <i class="fas fa-redo"></i>
                </button>
            </div>
        </div>

        <!-- Statistics Cards -->
        <div class="row mb-4">
            <div class="col-md-3">
                <div class="card bg-primary text-white">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="mb-0">Total Payments</h6>
                                <h3 class="mb-0"><?php echo e($payments->total()); ?></h3>
                            </div>
                            <i class="fas fa-credit-card fa-2x opacity-50"></i>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card bg-success text-white">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="mb-0">Total Amount</h6>
                                <h3 class="mb-0">Rs. <?php echo e(number_format($payments->sum('amount'), 0)); ?></h3>
                            </div>
                            <i class="fas fa-money-bill-wave fa-2x opacity-50"></i>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card bg-info text-white">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="mb-0">Completed</h6>
                                <h3 class="mb-0"><?php echo e($payments->where('status', 'completed')->count()); ?></h3>
                            </div>
                            <i class="fas fa-check-circle fa-2x opacity-50"></i>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card bg-warning text-white">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="mb-0">Pending</h6>
                                <h3 class="mb-0"><?php echo e($payments->where('status', 'pending')->count()); ?></h3>
                            </div>
                            <i class="fas fa-clock fa-2x opacity-50"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Payments Table -->
        <div class="table-responsive">
            <table class="table table-hover" id="paymentsTable">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Transaction ID</th>
                        <th>Customer</th>
                        <th>Property</th>
                        <th>Installment</th>
                        <th>Date</th>
                        <th>Amount</th>
                        <th>Method</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr class="payment-row"
                        data-status="<?php echo e($payment->status); ?>"
                        data-method="<?php echo e($payment->payment_method); ?>"
                        data-date="<?php echo e($payment->payment_date->format('Y-m-d')); ?>">
                        <td><?php echo e($loop->iteration); ?></td>
                        <td>
                            <code class="text-primary"><?php echo e($payment->transaction_id); ?></code>
                            <?php if($payment->reference_number): ?>
                                <div class="small text-muted">Ref: <?php echo e($payment->reference_number); ?></div>
                            <?php endif; ?>
                        </td>
                        <td>
                            <div class="d-flex align-items-center">
                                <div class="avatar bg-info text-white rounded-circle d-flex align-items-center justify-content-center me-2"
                                     style="width: 30px; height: 30px; font-size: 12px;">
                                    <?php echo e(substr($payment->customer->name, 0, 1)); ?>

                                </div>
                                <div>
                                    <strong><?php echo e($payment->customer->name); ?></strong>
                                    <div class="small text-muted"><?php echo e($payment->customer->phone); ?></div>
                                </div>
                            </div>
                        </td>
                        <td>
                            <strong><?php echo e($payment->installment->property->name); ?></strong>
                            <div class="small text-muted">
                                <?php echo e(Str::limit($payment->installment->property->location, 20)); ?>

                            </div>
                        </td>
                        <td>
                            <span class="badge bg-secondary">
                                #<?php echo e($payment->installment->installment_number); ?>

                            </span>
                            <div class="small text-muted">
                                Due: <?php echo e($payment->installment->due_date->format('d/m/Y')); ?>

                            </div>
                        </td>
                        <td>
                            <?php echo e($payment->payment_date->format('d M Y')); ?>

                            <div class="small text-muted">
                                <?php echo e($payment->created_at->format('h:i A')); ?>

                            </div>
                        </td>
                        <td>
                            <span class="fw-bold text-success">
                                Rs. <?php echo e(number_format($payment->amount, 2)); ?>

                            </span>
                        </td>
                        <td>
                            <?php
                                $methodColors = [
                                    'cash' => 'secondary',
                                    'bank_transfer' => 'primary',
                                    'cheque' => 'info',
                                    'online' => 'success'
                                ];
                                $methodIcons = [
                                    'cash' => 'money-bill',
                                    'bank_transfer' => 'university',
                                    'cheque' => 'file-invoice',
                                    'online' => 'globe'
                                ];
                            ?>
                            <span class="badge bg-<?php echo e($methodColors[$payment->payment_method] ?? 'secondary'); ?>">
                                <i class="fas fa-<?php echo e($methodIcons[$payment->payment_method] ?? 'money-bill'); ?> me-1"></i>
                                <?php echo e(ucfirst(str_replace('_', ' ', $payment->payment_method))); ?>

                            </span>
                        </td>
                        <td>
                            <?php
                                $statusColors = [
                                    'completed' => 'success',
                                    'pending' => 'warning',
                                    'failed' => 'danger',
                                    'refunded' => 'info'
                                ];
                                $statusIcons = [
                                    'completed' => 'check-circle',
                                    'pending' => 'clock',
                                    'failed' => 'times-circle',
                                    'refunded' => 'exchange-alt'
                                ];
                            ?>
                            <span class="badge bg-<?php echo e($statusColors[$payment->status] ?? 'secondary'); ?>">
                                <i class="fas fa-<?php echo e($statusIcons[$payment->status] ?? 'circle'); ?> me-1"></i>
                                <?php echo e(ucfirst($payment->status)); ?>

                            </span>
                        </td>
                        <td>
                            <div class="btn-group btn-group-sm" role="group">
                                <a href="<?php echo e(route('payments.show', $payment)); ?>"
                                   class="btn btn-info" title="View Details">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <a href="<?php echo e(route('payments.edit', $payment)); ?>"
                                   class="btn btn-warning" title="Edit Payment">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <?php if($payment->status != 'refunded'): ?>
                                    <button type="button" class="btn btn-danger"
                                            onclick="confirmRefund(<?php echo e($payment->id); ?>)"
                                            title="Mark as Refunded">
                                        <i class="fas fa-undo"></i>
                                    </button>
                                <?php endif; ?>
                                <form action="<?php echo e(route('payments.destroy', $payment)); ?>" method="POST"
                                      class="d-inline delete-form">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-dark"
                                            onclick="return confirm('Delete this payment record?')"
                                            title="Delete">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="10" class="text-center py-5">
                            <div class="empty-state">
                                <i class="fas fa-credit-card fa-3x text-muted mb-3"></i>
                                <h5>No Payments Found</h5>
                                <p class="text-muted">No payment records have been created yet.</p>
                                <a href="<?php echo e(route('payments.create')); ?>" class="btn btn-primary">
                                    <i class="fas fa-plus me-2"></i> Record First Payment
                                </a>
                            </div>
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <?php if($payments->hasPages()): ?>
        <div class="d-flex justify-content-between align-items-center mt-3">
            <div>
                Showing <?php echo e($payments->firstItem()); ?> to <?php echo e($payments->lastItem()); ?> of <?php echo e($payments->total()); ?> entries
            </div>
            <div>
                <?php echo e($payments->links()); ?>

            </div>
        </div>
        <?php endif; ?>
    </div>
</div>

<!-- Refund Modal -->
<div class="modal fade" id="refundModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Mark Payment as Refunded</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form id="refundForm" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    <input type="hidden" name="status" value="refunded">
                    <input type="hidden" name="payment_id" id="refundPaymentId">

                    <div class="mb-3">
                        <label for="refund_date" class="form-label">Refund Date</label>
                        <input type="date" class="form-control" id="refund_date" name="refund_date"
                               value="<?php echo e(date('Y-m-d')); ?>" required>
                    </div>

                    <div class="mb-3">
                        <label for="refund_reason" class="form-label">Refund Reason</label>
                        <textarea class="form-control" id="refund_reason" name="remarks"
                                  rows="3" placeholder="Enter reason for refund" required></textarea>
                    </div>

                    <div class="alert alert-warning">
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        This action cannot be undone. The payment amount will be deducted from the installment.
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="submit" form="refundForm" class="btn btn-danger">Confirm Refund</button>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    // Search functionality
    $('#searchInput').on('keyup', function() {
        const value = $(this).val().toLowerCase();
        $('#paymentsTable tbody tr').filter(function() {
            $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1);
        });
    });

    // Filter by status
    $('#statusFilter').on('change', function() {
        filterPayments();
    });

    // Filter by method
    $('#methodFilter').on('change', function() {
        filterPayments();
    });

    // Filter by date range
    $('#startDateFilter, #endDateFilter').on('change', function() {
        filterPayments();
    });

    function filterPayments() {
        const status = $('#statusFilter').val();
        const method = $('#methodFilter').val();
        const startDate = $('#startDateFilter').val();
        const endDate = $('#endDateFilter').val();

        $('#paymentsTable tbody tr').each(function() {
            const showStatus = !status || $(this).data('status') === status;
            const showMethod = !method || $(this).data('method') === method;
            const paymentDate = $(this).data('date');
            const showDate = (!startDate || paymentDate >= startDate) &&
                            (!endDate || paymentDate <= endDate);

            $(this).toggle(showStatus && showMethod && showDate);
        });
    }

    // Reset filters
    function resetFilters() {
        $('#searchInput').val('');
        $('#statusFilter').val('');
        $('#methodFilter').val('');
        $('#startDateFilter').val('');
        $('#endDateFilter').val('');
        $('#paymentsTable tbody tr').show();
    }

    // Confirm refund
    function confirmRefund(paymentId) {
        $('#refundPaymentId').val(paymentId);
        $('#refundForm').attr('action', `/payments/${paymentId}`);
        new bootstrap.Modal(document.getElementById('refundModal')).show();
    }

    // Export to Excel
    function exportToExcel() {
        const rows = [];
        const headers = ['Transaction ID', 'Customer', 'Property', 'Installment #', 'Payment Date', 'Amount', 'Method', 'Status', 'Reference'];

        $('#paymentsTable tbody tr').each(function() {
            const row = [];
            row.push($(this).find('td:nth-child(2) code').text().trim());
            row.push($(this).find('td:nth-child(3) strong').text().trim());
            row.push($(this).find('td:nth-child(4) strong').text().trim());
            row.push($(this).find('td:nth-child(5) span').text().replace('#', '').trim());
            row.push($(this).find('td:nth-child(6)').text().split('\n')[0].trim());
            row.push($(this).find('td:nth-child(7) span').text().replace('Rs.', '').trim());
            row.push($(this).find('td:nth-child(8) span').text().trim());
            row.push($(this).find('td:nth-child(9) span').text().trim());
            row.push($(this).find('td:nth-child(2) .small').text().replace('Ref:', '').trim() || 'N/A');

            rows.push(row.join(','));
        });

        const csvContent = [headers.join(','), ...rows].join('\n');
        const blob = new Blob([csvContent], { type: 'text/csv' });
        const url = window.URL.createObjectURL(blob);
        const a = document.createElement('a');
        a.href = url;
        a.download = `payments_${new Date().toISOString().split('T')[0]}.csv`;
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a);
    }

    // Initialize DataTable
    $(document).ready(function() {
        $('#paymentsTable').DataTable({
            paging: false,
            searching: false,
            info: false,
            order: [[5, 'desc']]
        });
    });
</script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .avatar {
        font-weight: bold;
    }

    .badge {
        min-width: 100px;
        text-align: center;
    }

    .payment-row:hover {
        background-color: rgba(67, 97, 238, 0.05);
        cursor: pointer;
    }

    .empty-state {
        opacity: 0.7;
    }

    code {
        font-size: 12px;
        background: #f8f9fa;
        padding: 2px 6px;
        border-radius: 4px;
        border: 1px solid #e9ecef;
    }

    .card.bg-primary,
    .card.bg-success,
    .card.bg-info,
    .card.bg-warning {
        transition: transform 0.3s;
    }

    .card.bg-primary:hover,
    .card.bg-success:hover,
    .card.bg-info:hover,
    .card.bg-warning:hover {
        transform: translateY(-5px);
    }
</style>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\wamp64\www\property-system\resources\views/payments/index.blade.php ENDPATH**/ ?>