<?php $__env->startSection('title', 'Customers Report'); ?>
<?php $__env->startSection('page-title', 'Customers Report'); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0">Customers Report</h5>
        <div>
            <button class="btn btn-success" onclick="exportToExcel()">
                <i class="fas fa-download me-2"></i> Export
            </button>
            <button class="btn btn-primary" onclick="window.print()">
                <i class="fas fa-print me-2"></i> Print
            </button>
        </div>
    </div>

    <div class="card-body">
        <!-- Filters -->
        <div class="row mb-4">
            <div class="col-md-3">
                <form method="GET" action="<?php echo e(route('reports.customers')); ?>" id="filterForm">
                    <select class="form-control" name="status" onchange="this.form.submit()">
                        <option value="all" <?php echo e(request('status') == 'all' ? 'selected' : ''); ?>>All Status</option>
                        <option value="active" <?php echo e(request('status') == 'active' ? 'selected' : ''); ?>>Active</option>
                        <option value="inactive" <?php echo e(request('status') == 'inactive' ? 'selected' : ''); ?>>Inactive</option>
                        <option value="blacklisted" <?php echo e(request('status') == 'blacklisted' ? 'selected' : ''); ?>>Blacklisted</option>
                    </select>
                </form>
            </div>
        </div>

        <!-- Summary Statistics -->
        <div class="row mb-4">
            <div class="col-md-3">
                <div class="card bg-primary text-white">
                    <div class="card-body text-center">
                        <h3 class="mb-0"><?php echo e($totalCustomers); ?></h3>
                        <small>Total Customers</small>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card bg-success text-white">
                    <div class="card-body text-center">
                        <h3 class="mb-0"><?php echo e($activeCustomers); ?></h3>
                        <small>Active Customers</small>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card bg-info text-white">
                    <div class="card-body text-center">
                        <h3 class="mb-0">Rs. <?php echo e(number_format($totalPayments, 0)); ?></h3>
                        <small>Total Payments</small>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card bg-warning text-white">
                    <div class="card-body text-center">
                        <h3 class="mb-0"><?php echo e($customers->where('status', 'inactive')->count()); ?></h3>
                        <small>Inactive Customers</small>
                    </div>
                </div>
            </div>
        </div>

        <!-- Customers Table -->
        <div class="table-responsive">
            <table class="table table-hover" id="customersTable">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Customer</th>
                        <th>Contact Info</th>
                        <th>Properties</th>
                        <th>Installments</th>
                        <th>Total Payments</th>
                        <th>Avg. Payment</th>
                        <th>Status</th>
                        <th>Member Since</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($loop->iteration); ?></td>
                        <td>
                            <div class="d-flex align-items-center">
                                <div class="avatar bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-2"
                                     style="width: 40px; height: 40px; font-size: 14px;">
                                    <?php echo e(substr($customer->name, 0, 1)); ?>

                                </div>
                                <div>
                                    <strong><?php echo e($customer->name); ?></strong>
                                    <div class="small text-muted">CNIC: <?php echo e($customer->cnic); ?></div>
                                </div>
                            </div>
                        </td>
                        <td>
                            <div><i class="fas fa-phone me-1 text-muted"></i> <?php echo e($customer->phone); ?></div>
                            <div><i class="fas fa-envelope me-1 text-muted"></i> <?php echo e($customer->email); ?></div>
                            <div class="small text-muted"><?php echo e(Str::limit($customer->address, 30)); ?></div>
                        </td>
                        <td class="text-center">
                            <span class="badge bg-info"><?php echo e($customer->properties_count); ?></span>
                        </td>
                        <td class="text-center">
                            <span class="badge bg-secondary"><?php echo e($customer->installments_count); ?></span>
                        </td>
                        <td>
                            <strong>Rs. <?php echo e(number_format($customer->payments_sum_amount ?? 0, 2)); ?></strong>
                            <div class="small text-muted"><?php echo e($customer->payments_count); ?> payments</div>
                        </td>
                        <td>
                            <?php
                                $avgPayment = $customer->payments_count > 0 ?
                                    ($customer->payments_sum_amount ?? 0) / $customer->payments_count : 0;
                            ?>
                            Rs. <?php echo e(number_format($avgPayment, 2)); ?>

                        </td>
                        <td>
                            <span class="badge bg-<?php echo e($customer->status == 'active' ? 'success' : ($customer->status == 'inactive' ? 'warning' : 'danger')); ?>">
                                <?php echo e(ucfirst($customer->status)); ?>

                            </span>
                        </td>
                        <td><?php echo e($customer->created_at->format('d M Y')); ?></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>

        <?php if($customers->isEmpty()): ?>
        <div class="text-center py-5">
            <i class="fas fa-users fa-3x text-muted mb-3"></i>
            <h5>No Customers Found</h5>
            <p class="text-muted">No customers match your search criteria.</p>
        </div>
        <?php endif; ?>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    function exportToExcel() {
        const rows = [];
        const headers = ['Customer Name', 'Phone', 'Email', 'CNIC', 'Address', 'Properties Count', 'Installments Count', 'Total Payments', 'Payment Count', 'Average Payment', 'Status', 'Member Since'];

        $('#customersTable tbody tr').each(function() {
            const row = [];
            row.push($(this).find('td:nth-child(2) strong').text().trim());
            row.push($(this).find('td:nth-child(3) div:nth-child(1)').text().replace('Phone:', '').trim());
            row.push($(this).find('td:nth-child(3) div:nth-child(2)').text().replace('Email:', '').trim());
            row.push($(this).find('td:nth-child(2) .small').text().replace('CNIC:', '').trim());
            row.push($(this).find('td:nth-child(3) .small').text().trim());
            row.push($(this).find('td:nth-child(4) span').text().trim());
            row.push($(this).find('td:nth-child(5) span').text().trim());
            row.push($(this).find('td:nth-child(6) strong').text().replace('Rs.', '').trim());
            row.push($(this).find('td:nth-child(6) .small').text().replace('payments', '').trim());
            row.push($(this).find('td:nth-child(7)').text().replace('Rs.', '').trim());
            row.push($(this).find('td:nth-child(8) span').text().trim());
            row.push($(this).find('td:nth-child(9)').text().trim());

            rows.push(row.join(','));
        });

        const csvContent = [headers.join(','), ...rows].join('\n');
        const blob = new Blob([csvContent], { type: 'text/csv' });
        const url = window.URL.createObjectURL(blob);
        const a = document.createElement('a');
        a.href = url;
        a.download = `customers_report_${new Date().toISOString().split('T')[0]}.csv`;
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a);
    }
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\wamp64\www\property-system\resources\views/reports/customers.blade.php ENDPATH**/ ?>