<?php $__env->startSection('title', 'Installment Details'); ?>
<?php $__env->startSection('page-title', 'Installment Details'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <!-- Installment Details -->
    <div class="col-md-4">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">Installment Information</h5>
                <div class="dropdown">
                    <button class="btn btn-sm btn-outline-secondary dropdown-toggle" type="button"
                            data-bs-toggle="dropdown">
                        <i class="fas fa-cog"></i>
                    </button>
                    <ul class="dropdown-menu">
                        <li>
                            <a class="dropdown-item" href="<?php echo e(route('installments.edit', $installment)); ?>">
                                <i class="fas fa-edit me-2"></i> Edit
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item" href="<?php echo e(route('payments.create', ['installment_id' => $installment->id])); ?>">
                                <i class="fas fa-credit-card me-2"></i> Record Payment
                            </a>
                        </li>
                        <?php if($installment->status != 'paid'): ?>
                        <li>
                            <form action="<?php echo e(route('installments.mark-paid', $installment)); ?>" method="POST"
                                  class="dropdown-item p-0">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="btn btn-link text-success p-0"
                                        onclick="return confirm('Mark this installment as paid?')">
                                    <i class="fas fa-check me-2"></i> Mark as Paid
                                </button>
                            </form>
                        </li>
                        <?php endif; ?>
                        <li><hr class="dropdown-divider"></li>
                        <li>
                            <form action="<?php echo e(route('installments.destroy', $installment)); ?>" method="POST"
                                  class="dropdown-item p-0">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-link text-danger p-0"
                                        onclick="return confirm('Are you sure? This will delete all associated payments.')">
                                    <i class="fas fa-trash me-2"></i> Delete
                                </button>
                            </form>
                        </li>
                    </ul>
                </div>
            </div>
            <div class="card-body">
                <div class="text-center mb-4">
                    <div class="avatar bg-primary text-white rounded-circle d-flex align-items-center justify-content-center mx-auto mb-3"
                         style="width: 80px; height: 80px; font-size: 32px;">
                        <?php echo e($installment->installment_number); ?>

                    </div>
                    <h4 class="mt-2">Installment #<?php echo e($installment->installment_number); ?></h4>
                    <p class="text-muted mb-3">
                        <?php
                            $statusColors = [
                                'paid' => 'success',
                                'pending' => 'warning',
                                'overdue' => 'danger',
                                'partial' => 'info'
                            ];
                            $statusIcons = [
                                'paid' => 'check-circle',
                                'pending' => 'clock',
                                'overdue' => 'exclamation-triangle',
                                'partial' => 'money-check-alt'
                            ];
                        ?>
                        <span class="badge bg-<?php echo e($statusColors[$installment->status]); ?> p-2 fs-6">
                            <i class="fas fa-<?php echo e($statusIcons[$installment->status]); ?> me-1"></i>
                            <?php echo e(ucfirst($installment->status)); ?>

                        </span>
                    </p>

                    <?php if($installment->isOverdue()): ?>
                        <div class="alert alert-danger py-2">
                            <i class="fas fa-exclamation-triangle me-2"></i>
                            <strong>Overdue!</strong> <?php echo e(now()->diffInDays($installment->due_date)); ?> days overdue
                        </div>
                    <?php endif; ?>
                </div>

                <!-- Property Information -->
                <div class="mb-4">
                    <h6 class="border-bottom pb-2">
                        <i class="fas fa-building me-2 text-primary"></i>Property Information
                    </h6>
                    <div class="d-flex align-items-center mb-3">
                        <div class="flex-shrink-0">
                            <div class="avatar bg-primary text-white rounded-circle d-flex align-items-center justify-content-center"
                                 style="width: 50px; height: 50px;">
                                <i class="fas fa-home"></i>
                            </div>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <h6 class="mb-0"><?php echo e($installment->property->name); ?></h6>
                            <p class="small text-muted mb-1">
                                <i class="fas fa-map-marker-alt"></i> <?php echo e($installment->property->location); ?>

                            </p>
                            <p class="small text-muted mb-0">
                                Total: <strong>Rs. <?php echo e(number_format($installment->property->total_price, 2)); ?></strong>
                            </p>
                        </div>
                        <div class="flex-shrink-0">
                            <a href="<?php echo e(route('properties.show', $installment->property)); ?>"
                               class="btn btn-sm btn-outline-primary">
                                <i class="fas fa-external-link-alt"></i>
                            </a>
                        </div>
                    </div>
                </div>

                <!-- Customer Information -->
                <div class="mb-4">
                    <h6 class="border-bottom pb-2">
                        <i class="fas fa-user me-2 text-info"></i>Customer Information
                    </h6>
                    <div class="d-flex align-items-center mb-3">
                        <div class="flex-shrink-0">
                            <div class="avatar bg-info text-white rounded-circle d-flex align-items-center justify-content-center"
                                 style="width: 50px; height: 50px; font-size: 18px;">
                                <?php echo e(substr($installment->customer->name, 0, 1)); ?>

                            </div>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <h6 class="mb-0"><?php echo e($installment->customer->name); ?></h6>
                            <p class="small text-muted mb-1">
                                <i class="fas fa-phone"></i> <?php echo e($installment->customer->phone); ?>

                            </p>
                            <p class="small text-muted mb-0">
                                <i class="fas fa-envelope"></i> <?php echo e($installment->customer->email); ?>

                            </p>
                        </div>
                        <div class="flex-shrink-0">
                            <a href="<?php echo e(route('customers.show', $installment->customer)); ?>"
                               class="btn btn-sm btn-outline-info">
                                <i class="fas fa-external-link-alt"></i>
                            </a>
                        </div>
                    </div>
                </div>

                <!-- Financial Details -->
                <div class="mb-4">
                    <h6 class="border-bottom pb-2">
                        <i class="fas fa-money-bill-wave me-2 text-success"></i>Financial Details
                    </h6>
                    <div class="row">
                        <div class="col-6 mb-3">
                            <small class="text-muted">Installment Amount</small>
                            <p class="mb-1 fs-5 fw-bold text-primary">
                                Rs. <?php echo e(number_format($installment->amount, 2)); ?>

                            </p>
                        </div>
                        <div class="col-6 mb-3">
                            <small class="text-muted">Paid Amount</small>
                            <p class="mb-1 fs-5 fw-bold text-success">
                                Rs. <?php echo e(number_format($installment->paid_amount, 2)); ?>

                            </p>
                        </div>
                        <div class="col-6">
                            <small class="text-muted">Remaining Amount</small>
                            <p class="mb-1 fs-5 fw-bold text-warning">
                                Rs. <?php echo e(number_format($installment->remaining_amount, 2)); ?>

                            </p>
                        </div>
                        <div class="col-6">
                            <small class="text-muted">Due Date</small>
                            <p class="mb-1">
                                <strong><?php echo e($installment->due_date->format('d M Y')); ?></strong>
                            </p>
                            <p class="small text-muted mb-0">
                                (<?php echo e($installment->due_date->diffForHumans()); ?>)
                            </p>
                        </div>
                    </div>
                </div>

                <!-- Payment Progress -->
                <div class="mb-4">
                    <div class="d-flex justify-content-between mb-2">
                        <small class="text-muted">Payment Progress</small>
                        <small class="text-muted">
                            <?php echo e(round(($installment->paid_amount / $installment->amount) * 100)); ?>%
                        </small>
                    </div>
                    <div class="progress" style="height: 10px;">
                        <div class="progress-bar bg-success" role="progressbar"
                             style="width: <?php echo e(($installment->paid_amount / $installment->amount) * 100); ?>%;"
                             aria-valuenow="<?php echo e(($installment->paid_amount / $installment->amount) * 100); ?>"
                             aria-valuemin="0" aria-valuemax="100">
                        </div>
                    </div>
                    <div class="d-flex justify-content-between mt-1">
                        <small class="text-muted">Rs. 0</small>
                        <small class="text-muted">Rs. <?php echo e(number_format($installment->amount, 0)); ?></small>
                    </div>
                </div>

                <!-- Quick Actions -->
                <div class="mt-4">
                    <div class="d-grid gap-2">
                        <?php if($installment->status != 'paid'): ?>
                            <a href="<?php echo e(route('payments.create', ['installment_id' => $installment->id])); ?>"
                               class="btn btn-success">
                                <i class="fas fa-credit-card me-2"></i> Record Payment
                            </a>
                        <?php endif; ?>
                        <a href="<?php echo e(route('installments.edit', $installment)); ?>"
                           class="btn btn-warning">
                            <i class="fas fa-edit me-2"></i> Edit Installment
                        </a>
                        <button type="button" class="btn btn-outline-primary" onclick="window.print()">
                            <i class="fas fa-print me-2"></i> Print Details
                        </button>
                    </div>
                </div>

                <?php if($installment->notes): ?>
                <div class="mt-4">
                    <h6 class="border-bottom pb-2">
                        <i class="fas fa-sticky-note me-2 text-secondary"></i>Notes
                    </h6>
                    <div class="alert alert-light">
                        <p class="mb-0"><?php echo e($installment->notes); ?></p>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Payment History & Details -->
    <div class="col-md-8">
        <!-- Payment History -->
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">Payment History</h5>
                <div>
                    <span class="badge bg-primary">
                        <?php echo e($installment->payments->count()); ?> payment(s)
                    </span>
                    <a href="<?php echo e(route('payments.create', ['installment_id' => $installment->id])); ?>"
                       class="btn btn-primary btn-sm ms-2">
                        <i class="fas fa-plus me-1"></i> Add Payment
                    </a>
                </div>
            </div>
            <div class="card-body">
                <?php if($installment->payments->count() > 0): ?>
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Transaction ID</th>
                                <th>Date</th>
                                <th>Amount</th>
                                <th>Method</th>
                                <th>Reference</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $installment->payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($loop->iteration); ?></td>
                                <td>
                                    <code><?php echo e($payment->transaction_id); ?></code>
                                    <?php if($payment->remarks): ?>
                                    <div class="small text-muted"><?php echo e(Str::limit($payment->remarks, 30)); ?></div>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php echo e($payment->payment_date->format('d M Y')); ?>

                                    <div class="small text-muted"><?php echo e($payment->payment_date->format('h:i A')); ?></div>
                                </td>
                                <td>
                                    <span class="fw-bold">Rs. <?php echo e(number_format($payment->amount, 2)); ?></span>
                                </td>
                                <td>
                                    <?php
                                        $methodColors = [
                                            'cash' => 'secondary',
                                            'bank_transfer' => 'primary',
                                            'cheque' => 'info',
                                            'online' => 'success'
                                        ];
                                    ?>
                                    <span class="badge bg-<?php echo e($methodColors[$payment->payment_method] ?? 'secondary'); ?>">
                                        <?php echo e(ucfirst(str_replace('_', ' ', $payment->payment_method))); ?>

                                    </span>
                                </td>
                                <td>
                                    <?php if($payment->reference_number): ?>
                                        <code><?php echo e($payment->reference_number); ?></code>
                                    <?php else: ?>
                                        <span class="text-muted">N/A</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <span class="badge bg-<?php echo e($payment->status == 'completed' ? 'success' :
                                                              ($payment->status == 'pending' ? 'warning' :
                                                              ($payment->status == 'failed' ? 'danger' : 'secondary'))); ?>">
                                        <?php echo e(ucfirst($payment->status)); ?>

                                    </span>
                                </td>
                                <td>
                                    <div class="btn-group btn-group-sm" role="group">
                                        <a href="<?php echo e(route('payments.show', $payment)); ?>"
                                           class="btn btn-info" title="View Details">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="<?php echo e(route('payments.edit', $payment)); ?>"
                                           class="btn btn-warning" title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <form action="<?php echo e(route('payments.destroy', $payment)); ?>"
                                              method="POST" class="d-inline">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-danger"
                                                    onclick="return confirm('Delete this payment?')"
                                                    title="Delete">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                        <tfoot>
                            <tr class="table-success">
                                <td colspan="3" class="text-end"><strong>Total Paid:</strong></td>
                                <td colspan="5">
                                    <strong>Rs. <?php echo e(number_format($installment->payments->where('status', 'completed')->sum('amount'), 2)); ?></strong>
                                </td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
                <?php else: ?>
                <div class="text-center py-5">
                    <div class="empty-state">
                        <i class="fas fa-credit-card fa-4x text-muted mb-4"></i>
                        <h4>No Payments Recorded</h4>
                        <p class="text-muted">No payments have been recorded for this installment yet.</p>
                        <a href="<?php echo e(route('payments.create', ['installment_id' => $installment->id])); ?>"
                           class="btn btn-primary">
                            <i class="fas fa-plus me-2"></i> Record First Payment
                        </a>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Installment Timeline -->
        <div class="card mt-4">
            <div class="card-header">
                <h5 class="mb-0">Installment Timeline</h5>
            </div>
            <div class="card-body">
                <div class="timeline">
                    <!-- Timeline Item 1: Creation -->
                    <div class="timeline-item">
                        <div class="timeline-marker bg-primary">
                            <i class="fas fa-calendar-plus text-white"></i>
                        </div>
                        <div class="timeline-content">
                            <div class="timeline-title">Installment Created</div>
                            <div class="timeline-date"><?php echo e($installment->created_at->format('d M Y, h:i A')); ?></div>
                            <div class="timeline-description">Installment schedule was created</div>
                        </div>
                    </div>

                    <!-- Timeline Item 2: Due Date -->
                    <div class="timeline-item">
                        <div class="timeline-marker bg-<?php echo e($installment->isOverdue() ? 'danger' : 'info'); ?>">
                            <i class="fas fa-calendar-check text-white"></i>
                        </div>
                        <div class="timeline-content">
                            <div class="timeline-title">Due Date</div>
                            <div class="timeline-date"><?php echo e($installment->due_date->format('d M Y')); ?></div>
                            <div class="timeline-description">
                                Payment due date
                                <?php if($installment->isOverdue()): ?>
                                    <span class="badge bg-danger ms-2">Overdue</span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>

                    <!-- Timeline Item 3: First Payment -->
                    <?php if($installment->paid_amount > 0): ?>
                    <div class="timeline-item">
                        <div class="timeline-marker bg-success">
                            <i class="fas fa-money-check-alt text-white"></i>
                        </div>
                        <div class="timeline-content">
                            <div class="timeline-title">First Payment</div>
                            <div class="timeline-date">
                                <?php echo e($installment->payments->first()->payment_date->format('d M Y')); ?>

                            </div>
                            <div class="timeline-description">
                                Rs. <?php echo e(number_format($installment->payments->first()->amount, 2)); ?> payment recorded
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>

                    <!-- Timeline Item 4: Last Update -->
                    <div class="timeline-item">
                        <div class="timeline-marker bg-secondary">
                            <i class="fas fa-sync-alt text-white"></i>
                        </div>
                        <div class="timeline-content">
                            <div class="timeline-title">Last Updated</div>
                            <div class="timeline-date"><?php echo e($installment->updated_at->format('d M Y, h:i A')); ?></div>
                            <div class="timeline-description">
                                Status: <span class="badge bg-<?php echo e($statusColors[$installment->status]); ?>">
                                    <?php echo e(ucfirst($installment->status)); ?>

                                </span>
                            </div>
                        </div>
                    </div>

                    <!-- Timeline Item 5: Fully Paid (if applicable) -->
                    <?php if($installment->status == 'paid'): ?>
                    <div class="timeline-item">
                        <div class="timeline-marker bg-success">
                            <i class="fas fa-check-circle text-white"></i>
                        </div>
                        <div class="timeline-content">
                            <div class="timeline-title">Fully Paid</div>
                            <div class="timeline-date">
                                <?php echo e($installment->payments->max('payment_date')->format('d M Y')); ?>

                            </div>
                            <div class="timeline-description">Installment completed successfully</div>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Related Installments -->
        <div class="card mt-4">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">Related Installments</h5>
                <a href="<?php echo e(route('properties.show', $installment->property)); ?>" class="btn btn-sm btn-outline-primary">
                    View All
                </a>
            </div>
            <div class="card-body">
                <?php
                    $relatedInstallments = $installment->property->installments()
                        ->where('id', '!=', $installment->id)
                        ->with('customer')
                        ->orderBy('installment_number', 'asc')
                        ->take(5)
                        ->get();
                ?>

                <?php if($relatedInstallments->count() > 0): ?>
                <div class="table-responsive">
                    <table class="table table-sm">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Customer</th>
                                <th>Due Date</th>
                                <th>Amount</th>
                                <th>Paid</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $relatedInstallments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $related): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr class="<?php echo e($related->id == $installment->id ? 'table-active' : ''); ?>">
                                <td>
                                    <strong>#<?php echo e($related->installment_number); ?></strong>
                                </td>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="avatar bg-info text-white rounded-circle d-flex align-items-center justify-content-center me-2"
                                             style="width: 25px; height: 25px; font-size: 10px;">
                                            <?php echo e(substr($related->customer->name, 0, 1)); ?>

                                        </div>
                                        <span><?php echo e(Str::limit($related->customer->name, 15)); ?></span>
                                    </div>
                                </td>
                                <td>
                                    <?php echo e($related->due_date->format('d/m/Y')); ?>

                                    <?php if($related->isOverdue()): ?>
                                        <br><small class="text-danger">Overdue</small>
                                    <?php endif; ?>
                                </td>
                                <td>Rs. <?php echo e(number_format($related->amount, 2)); ?></td>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="progress flex-grow-1 me-2" style="height: 5px;">
                                            <div class="progress-bar bg-success"
                                                 style="width: <?php echo e(($related->paid_amount / $related->amount) * 100); ?>%">
                                            </div>
                                        </div>
                                        <small><?php echo e(round(($related->paid_amount / $related->amount) * 100)); ?>%</small>
                                    </div>
                                </td>
                                <td>
                                    <span class="badge bg-<?php echo e($statusColors[$related->status]); ?>">
                                        <?php echo e(ucfirst($related->status)); ?>

                                    </span>
                                </td>
                                <td>
                                    <a href="<?php echo e(route('installments.show', $related)); ?>"
                                       class="btn btn-sm btn-outline-info">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <?php if($related->status != 'paid'): ?>
                                    <a href="<?php echo e(route('payments.create', ['installment_id' => $related->id])); ?>"
                                       class="btn btn-sm btn-outline-success">
                                        <i class="fas fa-credit-card"></i>
                                    </a>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
                <?php else: ?>
                <div class="text-center py-3">
                    <p class="text-muted mb-0">No other installments for this property.</p>
                </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Quick Stats -->
        <div class="row mt-4">
            <div class="col-md-4">
                <div class="card bg-primary text-white">
                    <div class="card-body text-center py-3">
                        <h2 class="mb-0"><?php echo e($installment->installment_number); ?></h2>
                        <small>Installment Number</small>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card bg-success text-white">
                    <div class="card-body text-center py-3">
                        <h2 class="mb-0"><?php echo e($installment->payments->count()); ?></h2>
                        <small>Total Payments</small>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card bg-info text-white">
                    <div class="card-body text-center py-3">
                        <h2 class="mb-0"><?php echo e(round(($installment->paid_amount / $installment->amount) * 100)); ?>%</h2>
                        <small>Completion</small>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Print View (Hidden) -->
<div id="printView" class="d-none">
    <div class="container p-5">
        <div class="text-center mb-4">
            <h2>Installment Details</h2>
            <h4>Installment #<?php echo e($installment->installment_number); ?></h4>
            <p>Generated on: <?php echo e(now()->format('d M Y, h:i A')); ?></p>
        </div>

        <div class="row">
            <div class="col-md-6">
                <h5>Property Information</h5>
                <p><strong>Name:</strong> <?php echo e($installment->property->name); ?></p>
                <p><strong>Location:</strong> <?php echo e($installment->property->location); ?></p>
                <p><strong>Total Price:</strong> Rs. <?php echo e(number_format($installment->property->total_price, 2)); ?></p>
            </div>
            <div class="col-md-6">
                <h5>Customer Information</h5>
                <p><strong>Name:</strong> <?php echo e($installment->customer->name); ?></p>
                <p><strong>Phone:</strong> <?php echo e($installment->customer->phone); ?></p>
                <p><strong>Email:</strong> <?php echo e($installment->customer->email); ?></p>
            </div>
        </div>

        <hr>

        <div class="row">
            <div class="col-md-6">
                <h5>Installment Details</h5>
                <p><strong>Amount:</strong> Rs. <?php echo e(number_format($installment->amount, 2)); ?></p>
                <p><strong>Paid Amount:</strong> Rs. <?php echo e(number_format($installment->paid_amount, 2)); ?></p>
                <p><strong>Remaining Amount:</strong> Rs. <?php echo e(number_format($installment->remaining_amount, 2)); ?></p>
            </div>
            <div class="col-md-6">
                <h5>Dates</h5>
                <p><strong>Due Date:</strong> <?php echo e($installment->due_date->format('d M Y')); ?></p>
                <p><strong>Status:</strong> <?php echo e(ucfirst($installment->status)); ?></p>
                <p><strong>Created:</strong> <?php echo e($installment->created_at->format('d M Y')); ?></p>
            </div>
        </div>

        <?php if($installment->payments->count() > 0): ?>
        <hr>
        <h5>Payment History</h5>
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>Transaction ID</th>
                    <th>Date</th>
                    <th>Amount</th>
                    <th>Method</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $installment->payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($payment->transaction_id); ?></td>
                    <td><?php echo e($payment->payment_date->format('d M Y')); ?></td>
                    <td>Rs. <?php echo e(number_format($payment->amount, 2)); ?></td>
                    <td><?php echo e(ucfirst(str_replace('_', ' ', $payment->payment_method))); ?></td>
                    <td><?php echo e(ucfirst($payment->status)); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td colspan="2" class="text-end"><strong>Total:</strong></td>
                    <td colspan="3">
                        <strong>Rs. <?php echo e(number_format($installment->payments->where('status', 'completed')->sum('amount'), 2)); ?></strong>
                    </td>
                </tr>
            </tbody>
        </table>
        <?php endif; ?>

        <hr>
        <div class="text-center mt-4">
            <p>This is a computer generated document. No signature required.</p>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    // Print functionality
    function printDetails() {
        const printContent = document.getElementById('printView').innerHTML;
        const originalContent = document.body.innerHTML;

        document.body.innerHTML = printContent;
        window.print();
        document.body.innerHTML = originalContent;
        window.location.reload();
    }

    // Initialize tooltips
    $(document).ready(function() {
        $('[data-bs-toggle="tooltip"]').tooltip();

        // Auto-refresh status for overdue installments
        <?php if($installment->status == 'pending' && $installment->isOverdue()): ?>
        setInterval(function() {
            fetch("<?php echo e(route('installments.show', $installment)); ?>", {
                headers: {
                    'X-Requested-With': 'XMLHttpRequest'
                }
            })
            .then(response => response.text())
            .then(html => {
                // You could update the status badge here if needed
                console.log('Status checked for overdue installment');
            });
        }, 60000); // Check every minute
        <?php endif; ?>
    });
</script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    /* Avatar Styles */
    .avatar {
        font-weight: bold;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    /* Badge Styles */
    .badge {
        min-width: 80px;
        text-align: center;
        padding: 8px 12px;
    }

    /* Progress Bar Styles */
    .progress {
        border-radius: 10px;
        overflow: hidden;
    }

    /* Timeline Styles */
    .timeline {
        position: relative;
        padding-left: 40px;
    }

    .timeline::before {
        content: '';
        position: absolute;
        left: 20px;
        top: 0;
        bottom: 0;
        width: 2px;
        background: linear-gradient(to bottom, #dee2e6, #6c757d);
    }

    .timeline-item {
        position: relative;
        margin-bottom: 25px;
    }

    .timeline-marker {
        position: absolute;
        left: -40px;
        top: 0;
        width: 40px;
        height: 40px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        border: 3px solid white;
        box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    }

    .timeline-content {
        padding-left: 20px;
    }

    .timeline-title {
        font-weight: 600;
        color: #495057;
        margin-bottom: 5px;
    }

    .timeline-date {
        font-size: 12px;
        color: #6c757d;
        margin-bottom: 5px;
    }

    .timeline-description {
        font-size: 14px;
        color: #495057;
    }

    /* Empty State */
    .empty-state {
        opacity: 0.7;
    }

    /* Hover Effects */
    .table-hover tbody tr:hover {
        background-color: rgba(67, 97, 238, 0.05);
    }

    /* Card Header Styles */
    .card-header {
        background-color: rgba(67, 97, 238, 0.05);
        border-bottom: 1px solid rgba(67, 97, 238, 0.1);
    }

    /* Print Styles */
    @media print {
        .no-print {
            display: none !important;
        }

        body {
            background: white !important;
            color: black !important;
        }

        .card {
            border: none !important;
            box-shadow: none !important;
        }
    }
</style>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\wamp64\www\property-system\resources\views/installments/show.blade.php ENDPATH**/ ?>