<?php $__env->startSection('title', 'Edit Installment'); ?>
<?php $__env->startSection('page-title', 'Edit Installment'); ?>

<?php $__env->startSection('content'); ?>
<div class="row justify-content-center">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Edit Installment Details</h5>
            </div>
            <div class="card-body">
                <form method="POST" action="<?php echo e(route('installments.update', $installment)); ?>" id="installmentForm">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="due_date" class="form-label">Due Date *</label>
                                <input type="date" class="form-control <?php $__errorArgs = ['due_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                       id="due_date" name="due_date"
                                       value="<?php echo e(old('due_date', $installment->due_date->format('Y-m-d'))); ?>"
                                       required>
                                <?php $__errorArgs = ['due_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="mb-3">
                                <label for="amount" class="form-label">Installment Amount (PKR) *</label>
                                <div class="input-group">
                                    <span class="input-group-text">Rs.</span>
                                    <input type="number" step="0.01" class="form-control <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                           id="amount" name="amount" value="<?php echo e(old('amount', $installment->amount)); ?>"
                                           placeholder="Enter installment amount" required min="0">
                                </div>
                                <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="paid_amount" class="form-label">Paid Amount (PKR)</label>
                                <div class="input-group">
                                    <span class="input-group-text">Rs.</span>
                                    <input type="number" step="0.01" class="form-control <?php $__errorArgs = ['paid_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                           id="paid_amount" name="paid_amount" value="<?php echo e(old('paid_amount', $installment->paid_amount)); ?>"
                                           placeholder="Enter paid amount" min="0" max="<?php echo e($installment->amount); ?>">
                                </div>
                                <div class="form-text">Cannot exceed installment amount: Rs. <?php echo e(number_format($installment->amount, 2)); ?></div>
                                <?php $__errorArgs = ['paid_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="mb-3">
                                <label for="status" class="form-label">Status *</label>
                                <select class="form-control <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        id="status" name="status" required>
                                    <option value="pending" <?php echo e(old('status', $installment->status) == 'pending' ? 'selected' : ''); ?>>Pending</option>
                                    <option value="paid" <?php echo e(old('status', $installment->status) == 'paid' ? 'selected' : ''); ?>>Paid</option>
                                    <option value="overdue" <?php echo e(old('status', $installment->status) == 'overdue' ? 'selected' : ''); ?>>Overdue</option>
                                    <option value="partial" <?php echo e(old('status', $installment->status) == 'partial' ? 'selected' : ''); ?>>Partial</option>
                                </select>
                                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="notes" class="form-label">Notes</label>
                        <textarea class="form-control <?php $__errorArgs = ['notes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                  id="notes" name="notes" rows="3"
                                  placeholder="Enter any notes about this installment"><?php echo e(old('notes', $installment->notes)); ?></textarea>
                        <?php $__errorArgs = ['notes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <!-- Installment Summary -->
                    <div class="card bg-light mb-4">
                        <div class="card-body">
                            <h6 class="card-title">Installment Summary</h6>
                            <div class="row">
                                <div class="col-md-4">
                                    <small class="text-muted">Property</small>
                                    <p class="mb-1"><strong><?php echo e($installment->property->name); ?></strong></p>
                                </div>
                                <div class="col-md-4">
                                    <small class="text-muted">Customer</small>
                                    <p class="mb-1"><strong><?php echo e($installment->customer->name); ?></strong></p>
                                </div>
                                <div class="col-md-4">
                                    <small class="text-muted">Installment Number</small>
                                    <p class="mb-1"><strong>#<?php echo e($installment->installment_number); ?></strong></p>
                                </div>
                                <div class="col-md-4">
                                    <small class="text-muted">Original Amount</small>
                                    <p class="mb-1"><strong>Rs. <?php echo e(number_format($installment->amount, 2)); ?></strong></p>
                                </div>
                                <div class="col-md-4">
                                    <small class="text-muted">Remaining Amount</small>
                                    <p class="mb-1"><strong>Rs. <?php echo e(number_format($installment->remaining_amount, 2)); ?></strong></p>
                                </div>
                                <div class="col-md-4">
                                    <small class="text-muted">Payment Progress</small>
                                    <div class="progress" style="height: 20px;">
                                        <div class="progress-bar bg-success" style="width: <?php echo e(($installment->paid_amount / $installment->amount) * 100); ?>%">
                                            <?php echo e(round(($installment->paid_amount / $installment->amount) * 100)); ?>%
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="alert alert-info">
                        <i class="fas fa-info-circle me-2"></i>
                        <strong>Note:</strong> Changing the status will affect the payment progress. If marking as paid, ensure the paid amount matches the installment amount.
                    </div>

                    <div class="mt-4">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save me-2"></i> Update Installment
                        </button>
                        <a href="<?php echo e(route('installments.show', $installment)); ?>" class="btn btn-info">
                            <i class="fas fa-eye me-2"></i> View Details
                        </a>
                        <a href="<?php echo e(route('installments.index')); ?>" class="btn btn-secondary">
                            <i class="fas fa-times me-2"></i> Cancel
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    $(document).ready(function() {
        // Validate paid amount doesn't exceed installment amount
        $('#paid_amount').on('change', function() {
            const installmentAmount = parseFloat('<?php echo e($installment->amount); ?>');
            const paidAmount = parseFloat($(this).val()) || 0;

            if (paidAmount > installmentAmount) {
                alert('Paid amount cannot exceed installment amount: Rs. ' + installmentAmount.toFixed(2));
                $(this).val(installmentAmount.toFixed(2));
            }
        });

        // Auto-update status based on paid amount
        $('#paid_amount').on('input', function() {
            const installmentAmount = parseFloat('<?php echo e($installment->amount); ?>');
            const paidAmount = parseFloat($(this).val()) || 0;

            if (paidAmount >= installmentAmount) {
                $('#status').val('paid');
            } else if (paidAmount > 0) {
                $('#status').val('partial');
            } else {
                $('#status').val('pending');
            }
        });

        // Form validation
        $('#installmentForm').validate({
            rules: {
                due_date: 'required',
                amount: {
                    required: true,
                    min: 0
                },
                paid_amount: {
                    min: 0,
                    max: parseFloat('<?php echo e($installment->amount); ?>')
                },
                status: 'required'
            },
            messages: {
                due_date: 'Please select due date',
                amount: {
                    required: 'Please enter installment amount',
                    min: 'Amount must be positive'
                },
                paid_amount: {
                    min: 'Paid amount cannot be negative',
                    max: 'Paid amount cannot exceed installment amount'
                },
                status: 'Please select status'
            },
            errorElement: 'div',
            errorClass: 'invalid-feedback',
            highlight: function(element) {
                $(element).addClass('is-invalid');
            },
            unhighlight: function(element) {
                $(element).removeClass('is-invalid');
            }
        });
    });
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\wamp64\www\property-system\resources\views/installments/edit.blade.php ENDPATH**/ ?>