<?php $__env->startSection('title', 'Reports'); ?>
<?php $__env->startSection('page-title', 'Reports Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <!-- Statistics Cards -->
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-primary h-100">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                            Total Properties</div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo e($stats['total_properties']); ?></div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-building fa-2x text-primary"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-success h-100">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                            Total Customers</div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo e($stats['total_customers']); ?></div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-users fa-2x text-success"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-info h-100">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                            Total Revenue</div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">
                            Rs. <?php echo e(number_format($stats['total_revenue'], 2)); ?>

                        </div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-dollar-sign fa-2x text-info"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-warning h-100">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                            Overdue Installments</div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo e($stats['overdue_installments']); ?></div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-exclamation-triangle fa-2x text-warning"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <!-- Report Cards -->
    <div class="col-xl-3 col-md-6 mb-4">
        <a href="<?php echo e(route('reports.properties')); ?>" class="card-link">
            <div class="card h-100">
                <div class="card-body text-center">
                    <i class="fas fa-building fa-3x text-primary mb-3"></i>
                    <h5 class="card-title">Properties Report</h5>
                    <p class="card-text text-muted">View all properties with financial details</p>
                </div>
            </div>
        </a>
    </div>

    <div class="col-xl-3 col-md-6 mb-4">
        <a href="<?php echo e(route('reports.customers')); ?>" class="card-link">
            <div class="card h-100">
                <div class="card-body text-center">
                    <i class="fas fa-users fa-3x text-success mb-3"></i>
                    <h5 class="card-title">Customers Report</h5>
                    <p class="card-text text-muted">Customer details with payment history</p>
                </div>
            </div>
        </a>
    </div>

    <div class="col-xl-3 col-md-6 mb-4">
        <a href="<?php echo e(route('reports.payments')); ?>" class="card-link">
            <div class="card h-100">
                <div class="card-body text-center">
                    <i class="fas fa-credit-card fa-3x text-info mb-3"></i>
                    <h5 class="card-title">Payments Report</h5>
                    <p class="card-text text-muted">All payment transactions with filters</p>
                </div>
            </div>
        </a>
    </div>

    <div class="col-xl-3 col-md-6 mb-4">
        <a href="<?php echo e(route('reports.installments')); ?>" class="card-link">
            <div class="card h-100">
                <div class="card-body text-center">
                    <i class="fas fa-calendar-alt fa-3x text-warning mb-3"></i>
                    <h5 class="card-title">Installments Report</h5>
                    <p class="card-text text-muted">Installment schedules and status</p>
                </div>
            </div>
        </a>
    </div>
</div>

<div class="row">
    <!-- Quick Report Generator -->
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Quick Report Generator</h5>
            </div>
            <div class="card-body">
                <form method="GET" action="<?php echo e(route('reports.generate')); ?>" id="quickReportForm">
                    <div class="mb-3">
                        <label for="report_type" class="form-label">Report Type</label>
                        <select class="form-control" id="report_type" name="type" required>
                            <option value="daily">Daily Payments</option>
                            <option value="weekly">Weekly Payments</option>
                            <option value="monthly">Monthly Payments</option>
                            <option value="custom">Custom Date Range</option>
                        </select>
                    </div>

                    <div id="custom_date_range" style="display: none;">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="start_date" class="form-label">Start Date</label>
                                <input type="date" class="form-control" id="start_date" name="start_date">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="end_date" class="form-label">End Date</label>
                                <input type="date" class="form-control" id="end_date" name="end_date">
                            </div>
                        </div>
                    </div>

                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-download me-2"></i> Generate Report
                    </button>
                </form>
            </div>
        </div>
    </div>

    <!-- Monthly Revenue Chart -->
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Monthly Revenue (<?php echo e(date('Y')); ?>)</h5>
            </div>
            <div class="card-body">
                <canvas id="revenueChart"></canvas>
            </div>
        </div>
    </div>
</div>

<div class="row mt-4">
    <!-- Recent Payments -->
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Recent Payments</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Transaction ID</th>
                                <th>Customer</th>
                                <th>Property</th>
                                <th>Amount</th>
                                <th>Date</th>
                                <th>Method</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $recentPayments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><code><?php echo e($payment->transaction_id); ?></code></td>
                                <td><?php echo e($payment->customer->name); ?></td>
                                <td><?php echo e($payment->installment->property->name); ?></td>
                                <td>Rs. <?php echo e(number_format($payment->amount, 2)); ?></td>
                                <td><?php echo e($payment->payment_date->format('d/m/Y')); ?></td>
                                <td>
                                    <span class="badge bg-primary">
                                        <?php echo e(ucfirst(str_replace('_', ' ', $payment->payment_method))); ?>

                                    </span>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    $(document).ready(function() {
        // Toggle custom date range
        $('#report_type').on('change', function() {
            if ($(this).val() === 'custom') {
                $('#custom_date_range').show();
                $('#start_date, #end_date').prop('required', true);
            } else {
                $('#custom_date_range').hide();
                $('#start_date, #end_date').prop('required', false);
            }
        });

        // Revenue Chart
        const revenueCtx = document.getElementById('revenueChart').getContext('2d');
        const revenueChart = new Chart(revenueCtx, {
            type: 'bar',
            data: {
                labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
                datasets: [{
                    label: 'Revenue (Rs.)',
                    data: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
                    backgroundColor: 'rgba(54, 162, 235, 0.5)',
                    borderColor: 'rgba(54, 162, 235, 1)',
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            callback: function(value) {
                                return 'Rs. ' + value.toLocaleString();
                            }
                        }
                    }
                },
                plugins: {
                    tooltip: {
                        callbacks: {
                            label: function(context) {
                                return 'Revenue: Rs. ' + context.parsed.y.toLocaleString();
                            }
                        }
                    }
                }
            }
        });

        // Update chart with actual data
        const monthlyData = <?php echo json_encode($monthlyRevenue, 15, 512) ?>;
        monthlyData.forEach(item => {
            const monthIndex = item.month - 1;
            revenueChart.data.datasets[0].data[monthIndex] = parseFloat(item.total);
        });
        revenueChart.update();
    });
</script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .card-link {
        text-decoration: none;
        color: inherit;
    }

    .card-link .card {
        transition: transform 0.3s, box-shadow 0.3s;
    }

    .card-link:hover .card {
        transform: translateY(-5px);
        box-shadow: 0 10px 20px rgba(0,0,0,0.1);
    }

    .card-title {
        color: #333;
        font-weight: 600;
    }
</style>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\wamp64\www\property-system\resources\views/reports/index.blade.php ENDPATH**/ ?>