<?php $__env->startSection('title', 'Customers Management'); ?>
<?php $__env->startSection('page-title', 'Customers'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Header with Actions -->
    <div class="row mb-4">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h5 class="mb-0">Customer Management</h5>
                            <p class="text-muted mb-0">Manage all customer records and documents</p>
                        </div>
                        <div>
                            <a href="<?php echo e(route('customers.create')); ?>" class="btn btn-primary">
                                <i class="fas fa-plus-circle me-2"></i> Add New Customer
                            </a>
                            <button class="btn btn-outline-secondary" data-bs-toggle="modal" data-bs-target="#filterModal">
                                <i class="fas fa-filter me-2"></i> Filter
                            </button>
                            <a href="<?php echo e(route('customers.export')); ?>" class="btn btn-success">
                                <i class="fas fa-file-export me-2"></i> Export
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Stats Cards -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card bg-primary text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="text-uppercase">Total Customers</h6>
                            <h3 class="mb-0"><?php echo e($totalCustomers); ?></h3>
                        </div>
                        <i class="fas fa-users fa-2x opacity-50"></i>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-success text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="text-uppercase">Active Customers</h6>
                            <h3 class="mb-0"><?php echo e($activeCustomers); ?></h3>
                        </div>
                        <i class="fas fa-user-check fa-2x opacity-50"></i>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-warning text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="text-uppercase">Pending Documents</h6>
                            <h3 class="mb-0"><?php echo e($customersWithMissingDocs); ?></h3>
                        </div>
                        <i class="fas fa-file-upload fa-2x opacity-50"></i>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-info text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="text-uppercase">This Month</h6>
                            <h3 class="mb-0"><?php echo e($thisMonthCustomers); ?></h3>
                        </div>
                        <i class="fas fa-calendar-alt fa-2x opacity-50"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Customers Table -->
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0">All Customers (<?php echo e($customers->total()); ?>)</h6>
                </div>
                <div class="card-body">
                    <?php if($customers->count() > 0): ?>
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Customer</th>
                                        <th>Contact Info</th>
                                        <th>Status</th>
                                        <th>Documents</th>
                                        <th>Financial</th>
                                        <th>Created</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <?php if($customer->customer_picture): ?>
                                                        <img src="<?php echo e(asset('storage/' . $customer->customer_picture)); ?>"
                                                             alt="<?php echo e($customer->name); ?>"
                                                             class="rounded-circle me-2"
                                                             width="40" height="40" style="object-fit: cover;">
                                                    <?php else: ?>
                                                        <div class="bg-light rounded-circle d-flex align-items-center justify-content-center me-2"
                                                             style="width: 40px; height: 40px;">
                                                            <span class="text-muted"><?php echo e($customer->initials); ?></span>
                                                        </div>
                                                    <?php endif; ?>
                                                    <div>
                                                        <h6 class="mb-0"><?php echo e($customer->name); ?></h6>
                                                        <small class="text-muted">
                                                            <i class="fas fa-id-card me-1"></i> <?php echo e($customer->cnic); ?>

                                                        </small>
                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                <div>
                                                    <div>
                                                        <i class="fas fa-envelope me-1 text-muted"></i>
                                                        <a href="mailto:<?php echo e($customer->email); ?>" class="text-decoration-none">
                                                            <?php echo e($customer->email ?? 'N/A'); ?>

                                                        </a>
                                                    </div>
                                                    <div class="mt-1">
                                                        <i class="fas fa-phone me-1 text-muted"></i>
                                                        <a href="tel:+92<?php echo e($customer->phone); ?>" class="text-decoration-none">
                                                            +92 <?php echo e($customer->phone); ?>

                                                        </a>
                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                <span class="badge bg-<?php echo e($customer->status == 'active' ? 'success' : ($customer->status == 'inactive' ? 'warning' : 'danger')); ?>">
                                                    <?php echo e(ucfirst($customer->status)); ?>

                                                </span>
                                            </td>
                                            <td>
                                                <div class="document-indicators">
                                                    <div class="d-flex align-items-center mb-1">
                                                        <span class="badge bg-<?php echo e($customer->cnic_front ? 'success' : 'warning'); ?> me-1"
                                                              title="CNIC Front">
                                                            <i class="fas fa-id-card"></i>
                                                        </span>
                                                        <span class="badge bg-<?php echo e($customer->cnic_back ? 'success' : 'warning'); ?> me-1"
                                                              title="CNIC Back">
                                                            <i class="fas fa-id-card"></i>
                                                        </span>
                                                        <span class="badge bg-<?php echo e($customer->customer_picture ? 'success' : 'warning'); ?> me-1"
                                                              title="Picture">
                                                            <i class="fas fa-camera"></i>
                                                        </span>
                                                        <span class="badge bg-<?php echo e(!empty($customer->other_documents) ? 'success' : 'secondary'); ?>"
                                                              title="Other Documents">
                                                            <?php echo e(!empty($customer->other_documents) ? count($customer->other_documents) : 0); ?>

                                                        </span>
                                                    </div>
                                                    <small class="text-muted">
                                                        <?php
                                                            $docCount = ($customer->cnic_front ? 1 : 0) +
                                                                       ($customer->cnic_back ? 1 : 0) +
                                                                       ($customer->customer_picture ? 1 : 0) +
                                                                       (count($customer->other_documents ?? []));
                                                        ?>
                                                        <?php echo e($docCount); ?> documents
                                                    </small>
                                                </div>
                                            </td>
                                            <td>
                                                <div>
                                                    <div class="mb-1">
                                                        <small class="text-muted">Paid:</small>
                                                        <strong>Rs. <?php echo e(number_format($customer->payments_sum_amount ?? 0, 0)); ?></strong>
                                                    </div>
                                                    <div>
                                                        <small class="text-muted">Installments:</small>
                                                        <strong><?php echo e($customer->installments_count); ?></strong>
                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                <small class="text-muted">
                                                    <?php echo e($customer->created_at->format('d M, Y')); ?>

                                                </small>
                                            </td>
                                            <td>
                                                <div class="btn-group" role="group">
                                                    <a href="<?php echo e(route('customers.show', $customer->id)); ?>"
                                                       class="btn btn-sm btn-info" title="View">
                                                        <i class="fas fa-eye"></i>
                                                    </a>
                                                    <a href="<?php echo e(route('customers.edit', $customer->id)); ?>"
                                                       class="btn btn-sm btn-primary" title="Edit">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    <a href="<?php echo e(route('customers.download-all', $customer->id)); ?>"
                                                       class="btn btn-sm btn-success" title="Download All Documents">
                                                        <i class="fas fa-download"></i>
                                                    </a>
                                                    <form action="<?php echo e(route('customers.destroy', $customer->id)); ?>"
                                                          method="POST" class="d-inline">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('DELETE'); ?>
                                                        <button type="submit" class="btn btn-sm btn-danger"
                                                                onclick="return confirm('Are you sure you want to delete this customer? This action cannot be undone.')"
                                                                title="Delete">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    </form>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>

                        <!-- Pagination -->
                        <div class="d-flex justify-content-between align-items-center mt-3">
                            <div>
                                <p class="mb-0">Showing <?php echo e($customers->firstItem()); ?> to <?php echo e($customers->lastItem()); ?> of <?php echo e($customers->total()); ?> entries</p>
                            </div>
                            <div>
                                <?php echo e($customers->links()); ?>

                            </div>
                        </div>
                    <?php else: ?>
                        <div class="text-center py-5">
                            <i class="fas fa-users fa-4x text-muted mb-4"></i>
                            <h5 class="text-muted">No Customers Found</h5>
                            <p class="text-muted mb-4">Get started by adding your first customer</p>
                            <a href="<?php echo e(route('customers.create')); ?>" class="btn btn-primary">
                                <i class="fas fa-plus-circle me-2"></i> Add First Customer
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Filter Modal -->
<div class="modal fade" id="filterModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Filter Customers</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="GET" action="<?php echo e(route('customers.index')); ?>">
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Status</label>
                        <select name="status" class="form-control">
                            <option value="">All Status</option>
                            <option value="active" <?php echo e(request('status') == 'active' ? 'selected' : ''); ?>>Active</option>
                            <option value="inactive" <?php echo e(request('status') == 'inactive' ? 'selected' : ''); ?>>Inactive</option>
                            <option value="blacklisted" <?php echo e(request('status') == 'blacklisted' ? 'selected' : ''); ?>>Blacklisted</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Documents Status</label>
                        <select name="documents" class="form-control">
                            <option value="">All Documents Status</option>
                            <option value="complete" <?php echo e(request('documents') == 'complete' ? 'selected' : ''); ?>>Complete Documents</option>
                            <option value="incomplete" <?php echo e(request('documents') == 'incomplete' ? 'selected' : ''); ?>>Incomplete Documents</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Search</label>
                        <input type="text" name="search" class="form-control" value="<?php echo e(request('search')); ?>"
                               placeholder="Search by name, email, phone or CNIC">
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">From Date</label>
                                <input type="date" name="from_date" class="form-control" value="<?php echo e(request('from_date')); ?>">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">To Date</label>
                                <input type="date" name="to_date" class="form-control" value="<?php echo e(request('to_date')); ?>">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <a href="<?php echo e(route('customers.index')); ?>" class="btn btn-secondary">Reset</a>
                    <button type="submit" class="btn btn-primary">Apply Filters</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    $(document).ready(function() {
        // Filter modal trigger
        $('[data-bs-target="#filterModal"]').on('click', function() {
            $('#filterModal').modal('show');
        });
    });
</script>
<style>
    .document-indicators .badge {
        cursor: default;
        font-size: 0.75rem;
        padding: 0.25rem 0.5rem;
    }
    .table tbody tr:hover {
        background-color: #f8f9fa;
    }
    .table th {
        font-weight: 600;
        color: #495057;
    }
</style>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\wamp64\www\property-system\resources\views/customers/index.blade.php ENDPATH**/ ?>